<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RemoveFilter("gzip_compression");
  RemoveFilter("runtime");
  RemoveFilter("start_session");
  RunPreFilter(__FILE__);

  $tpl = new Template;

  if ($type == 'top') {
    $rss_template = 'rss.top.xml';
    $query = "select * from idx_link
              where suspended = 0 and top_rated = 1
              order by date desc, last_updated desc limit $top_rated_limit";
    $rss['link'] = "$site_url/top.php";
  }
  elseif ($type == 'pick') {
    $rss_template = 'rss.pick.xml';
    $query = "select * from idx_link
              where suspended = 0 and pick=1
              order by date desc, last_updated desc";
    $rss['link'] = "$site_url/pick.php";
  }
  elseif ($type == 'hot') {
    $rss_template = 'rss.hot.xml';
    $query = "select * from idx_link
              where suspended = 0 and hot = 1
              order by hits desc limit $hot_limit";
    $rss['link'] = "$site_url/hot.php";
  }
  elseif ($type == 'random') {
    $rss_template = 'rss.random.xml';
    $query = "select * from idx_link
              where suspended = 0
              order by rand() limit 10";
    $rss['link'] = "$site_url";
  }
  elseif ($type == 'new') {
    $rss_template = 'rss.new.xml';
    $query = "select *, if (last_updated != '0000-00-00 00:00:00', last_updated, date) date_order
              from idx_link
              where suspended = 0 and (new=1 or updated=1)
              order by date_order desc limit $new_limit";
    $rss['link'] = "$site_url/new.php";
  }
  elseif ($type == 'category') {
    $rss_template = 'rss.category.xml';
    $query = "select *, if (last_updated != '0000-00-00 00:00:00', last_updated, date) date_order
              from idx_link
              where suspended = 0 and category_id = '$cat'
              order by date_order desc limit $max_rows";
    if (GetModRewriteStatus()=='1') {
      $query_cat = "select a.*, b.path
                    from idx_category a
                         left join idx_category_path b on (a.category_id = b.category_id)
                    where a.category_id = '$cat'";
      $category = $dbConn->FetchOne($query_cat);
      $tpl->assign("category", $category);
      $mod_rewrite_pattern = GetModRewritePatternCategory();
      $mod_rewrite_pattern = str_replace('{$cat_name}',$category['name'],$mod_rewrite_pattern);
      $mod_rewrite_pattern = str_replace('{$cat_id}',$cat,$mod_rewrite_pattern);
      $mod_rewrite_pattern = str_replace('{$page}','1',$mod_rewrite_pattern);
      if (strpos($mod_rewrite_pattern, '{$cat_path}') !== FALSE) {
        $mod_rewrite_pattern = substr($mod_rewrite_pattern, 0, strrpos($mod_rewrite_pattern, '/') + 1);
        $cat_path = SEOReplace(str_replace($category_separator, 'indexuslash', $category['path']));
        $cat_path = str_replace('indexuslash', '/', $cat_path);
        $mod_rewrite_pattern = str_replace('{$cat_path}',$cat_path,$mod_rewrite_pattern);
        $mod_rewrite_pattern = str_replace('//', '/', $mod_rewrite_pattern);
      }
      $cat_url   = strtolower($mod_rewrite_pattern);
    }
    else {
      $cat_url   = strtolower("browse.php?cat=$cat_id");
    }
    $rss['link'] = "$site_url/$cat_url";
  }
  else {
    RunPostFilter(__FILE__);
  }

  $result = $dbConn->Execute($query);
  while ($row = @$result->FetchRow()) {
    if (!$row['last_updated'] || strtotime($row['date']) > strtotime($row['last_updated'])) {
      $row['last_updated'] = $row['date'];
    }
    $row['last_updated'] = date('r', @strtotime($row['last_updated']));

    // title for mod rewrite
    $title_mod = strtolower($row[title]);
    $title_mod = SEOReplace($title_mod);

    // detail url <%$detail_url%>
    if (GetModRewriteStatus()=='1') {
      $mod_rewrite_pattern = GetModRewritePatternDetail();
      $mod_rewrite_pattern = str_replace('{$link_title}',$title_mod,$mod_rewrite_pattern);
      $mod_rewrite_pattern = str_replace('{$link_id}',$row['link_id'],$mod_rewrite_pattern);
      $detail_page_url     = strtolower($mod_rewrite_pattern);
    }
    else {
      $detail_page_url     = "detail.php?linkid=$row[link_id]";
    }

    $row['detail_page_url'] = "$site_url/$detail_page_url";
    $links[] = $row;
  }

  $rss['pub_date'] = date('r');
  header('Content-type: text/xml');
  $tpl->assign("site_name", $site_name);
  $tpl->assign("rss", $rss);
  $tpl->assign("links", $links);
  $tpl->display("rss/$rss_template");

  RunPostFilter(__FILE__);

?>